/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns;

import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.client.animation.BulletEjectAnimation;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.common.IShootProps;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.entity.projectile.Pellet;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.api.AnimationList;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframeProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractShotgun
extends GunItem {
    public AbstractShotgun(String name, Item.Properties properties) {
        super(name, properties);
    }

    public abstract int getPelletCount(LivingEntity var1, ItemStack var2);

    @Override
    protected AbstractProjectile makeProjectile(World level, LivingEntity shooter) {
        return new Pellet((EntityType<? extends Pellet>)((EntityType)ModEntities.PELLET.get()), level, shooter);
    }

    @Override
    public void handleShootProjectileAction(World world, LivingEntity entity, ItemStack stack, IShootProps props) {
        int pellets = this.getPelletCount(entity, stack);
        for (int i = 0; i < pellets; ++i) {
            this.shootProjectile(world, entity, stack, props);
        }
    }

    @Override
    protected float getInaccuracy(IShootProps props, LivingEntity entity) {
        return 2.4f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onShoot(PlayerEntity player, ItemStack stack) {
        ResourceLocation animationPath = this.getBulletEjectAnimationPath();
        int animationLength = this.getShootAnimationLength(player);
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        this.handleAnimation(animationPath, animationLength, pipeline);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void handleAnimation(ResourceLocation animationPath, int length, IAnimationPipeline pipeline) {
        BulletEjectAnimation animation = AnimationUtils.createAnimation(animationPath, provider -> new BulletEjectAnimation((IKeyframeProvider)provider, length));
        AnimationList.enqueue(ModAnimations.BULLET_EJECTION, animation);
    }

    protected int getShootAnimationLength(PlayerEntity player) {
        IPlayerData data = PlayerData.getUnsafe(player);
        IAttributeProvider provider = data.getAttributes();
        return this.getFirerate(provider) - 5;
    }
}

